/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.core;

import com.aptana.core.IMap;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.git.core.GitPlugin;
import com.aptana.git.core.model.GitIndex;
import com.aptana.git.core.model.GitRepository;
import com.aptana.git.core.model.IGitRepositoryManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;

class GitResourceListener
implements IResourceChangeListener {
    private static int INTERESTING_CHANGES = 323840;

    GitResourceListener() {
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event == null || event.getDelta() == null) {
            return;
        }
        Map<Object, Object> reposToRefresh = Collections.emptyMap();
        Set<Object> projectsToAttach = Collections.emptySet();
        ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
        try {
            event.getDelta().accept((IResourceDeltaVisitor)visitor, true);
            reposToRefresh = visitor.getRepositoriestoRefresh();
            projectsToAttach = visitor.getProjectsToAttach();
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)GitPlugin.getDefault(), (Throwable)e, (String)"com.aptana.git.core/debug");
        }
        if (this.autoAttachGitRepos() && !projectsToAttach.isEmpty()) {
            new GitAutoAttachProjectJob("Attaching Git repos", projectsToAttach).schedule();
        }
        if (reposToRefresh.isEmpty()) {
            return;
        }
        for (Map.Entry<Object, Object> entry : reposToRefresh.entrySet()) {
            GitIndex index;
            Set resources;
            final GitRepository repo = (GitRepository)entry.getKey();
            if (repo == null || CollectionsUtil.isEmpty((Collection)(resources = (Set)entry.getValue())) || this.dontRefresh(((IResource)resources.iterator().next()).getProject()) || (index = repo.index()) == null || CollectionsUtil.isEmpty((Collection)resources)) continue;
            List filePaths = CollectionsUtil.map((Collection)resources, (IMap)new IMap<IResource, IPath>(){

                public IPath map(IResource item) {
                    return repo.relativePath(item);
                }
            });
            index.refreshAsync(filePaths);
        }
    }

    protected boolean dontRefresh(IProject project) {
        return !Platform.getPreferencesService().getBoolean(GitPlugin.getPluginId(), "refresh_git_index_when_resources_change", true, new IScopeContext[]{new ProjectScope(project), InstanceScope.INSTANCE, DefaultScope.INSTANCE});
    }

    private boolean autoAttachGitRepos() {
        return Platform.getPreferencesService().getBoolean(GitPlugin.getPluginId(), "auto_attach_repos", true, null);
    }

    private IGitRepositoryManager getGitRepositoryManager() {
        return GitPlugin.getDefault().getGitRepositoryManager();
    }

    private GitRepository getRepo(IResource resource) {
        if (resource == null) {
            return null;
        }
        IProject project = resource.getProject();
        if (project == null) {
            return null;
        }
        return this.getGitRepositoryManager().getAttached(project);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class GitAutoAttachProjectJob
    extends Job {
        private Set<IProject> projectsToAttach;

        private GitAutoAttachProjectJob(String name, Set<IProject> projectsToAttach) {
            super(name);
            this.projectsToAttach = projectsToAttach;
            EclipseUtil.setSystemForJob((Job)this);
            this.setPriority(20);
        }

        protected IStatus run(IProgressMonitor monitor) {
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(10 * this.projectsToAttach.size()));
            MultiStatus multi = new MultiStatus(GitPlugin.getPluginId(), 0, null, null);
            multi.add(Status.OK_STATUS);
            for (IProject project : this.projectsToAttach) {
                try {
                    if (!project.isAccessible()) continue;
                    GitResourceListener.this.getGitRepositoryManager().attachExisting(project, (IProgressMonitor)sub.newChild(10));
                }
                catch (CoreException e) {
                    multi.add(e.getStatus());
                }
            }
            return multi;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        private Map<GitRepository, Set<IResource>> reposToRefresh = new HashMap<GitRepository, Set<IResource>>();
        private Set<IProject> projectsToAttach = new HashSet<IProject>();

        private ResourceDeltaVisitor() {
        }

        public Set<IProject> getProjectsToAttach() {
            return this.projectsToAttach;
        }

        public Map<GitRepository, Set<IResource>> getRepositoriestoRefresh() {
            return this.reposToRefresh;
        }

        public boolean visit(IResourceDelta delta) {
            GitRepository mapping;
            if (delta.getKind() == 4 && (delta.getFlags() & INTERESTING_CHANGES) == 0) {
                return true;
            }
            IResource resource = delta.getResource();
            if (resource != null && resource instanceof IProject && delta.getKind() == 1) {
                mapping = GitResourceListener.this.getRepo(resource);
                IProject project = (IProject)resource;
                if (mapping == null) {
                    this.projectsToAttach.add(project);
                    return false;
                }
            }
            if (resource.getType() == 8) {
                return true;
            }
            if (resource.getType() == 4 && !resource.isAccessible()) {
                return false;
            }
            mapping = GitResourceListener.this.getRepo(resource);
            if (mapping == null) {
                return true;
            }
            if (resource.isTeamPrivateMember()) {
                return false;
            }
            Set<IResource> resources = this.reposToRefresh.get(mapping);
            if (resources == null) {
                resources = new HashSet<IResource>();
            }
            resources.add(resource);
            this.reposToRefresh.put(mapping, resources);
            return delta.getKind() != 4 || (delta.getFlags() & 0x4000) <= 1;
        }
    }
}

